%Multi-layer adsorption function code

function dydt=KM_FILM_adsorption_F(t,y)

global W sigma adsorption_layers L_BL_close L_BL_far JJ A_surf
global a0_room_surf kd_room_surf a0 kd A V_BL_close
global V_BL_far delta_BL_close delta_BL_far Dg 
global NCom mfp 

dydt=zeros(NCom*(L_BL_close+L_BL_far+adsorption_layers+3),1);

%Selecting species present in each experiment
%1. DEHP, 2. DEHT, 3.DINCH, 4.DINP, 5.DIDP, 6.DEHA, 7.ATBC
if JJ==1 || JJ==2 || JJ==3 || JJ==4 || JJ==5 || JJ==6 || JJ==7
    Species=1;
elseif JJ==8
    Species=2;
elseif JJ==9
    Species=5;
elseif JJ==10
    Species=[1,6];
elseif JJ==11
    Species=[2,4];
elseif JJ==12
    Species=[2,6];
elseif JJ==13
    Species=[1,2,3,4];
elseif JJ==14 || JJ==15
    Species=[2,7];
elseif  JJ==16 || JJ==17
    Species=[2];
end

Species_number_1=size(Species); 
Species_number=Species_number_1(1,2); %Number of species 

%%%%EQN 2 in the Lakey et al.%%%%
for m=L_BL_close+L_BL_far+adsorption_layers+3
for j=L_BL_close+L_BL_far+3:L_BL_close+L_BL_far+3+adsorption_layers
%Surface area of a layer (cm2)
Thetas(j-L_BL_close-L_BL_far-2,1)=sigma(1)*y(j)+sigma(2)*y(m+j)+sigma(3)*y(2*m+j)+sigma(4)*y(3*m+j)+sigma(5)*y(4*m+j)+sigma(6)*y(5*m+j)+sigma(7)*y(6*m+j);
end
end
%-------------------------------------
%%%EQN 3 in Lakey et al.%%%%%%
%Surface area of empty adsorption sites (surface material, layer 1)
SA_ads_layer(1,1)=A_surf-Thetas(1,1); 
for j=1:adsorption_layers
%Surface area of empty adsorption sites (adsorption layers)
    SA_ads_layer(j+1,1)=Thetas(j,1)-Thetas(j+1,1);
end
%------------------------------------
%%%EQN 4 in Lakey et al.%%%%%%%
for j=1:adsorption_layers
    Covered_molec(j,1)=Thetas(j+1,1); %Covered surface area of a layer (cm2)
    Uncovered_molec(j,1)=Thetas(j,1)-Covered_molec(j,1); %Uncovered surface area of a layer (cm2)
    if (Thetas(j,1))<=0
      Uncovered_fract(j,1)=0; %If there are no molecules in the adsorption layer the fraction of uncovered molecules in a layer is set to zero
    else
    %Fraction of uncovered molecules in a layer
    Uncovered_fract(j,1)=SA_ads_layer(j+1,1)./Thetas(j,1); 
    end
end
Covered_molec(adsorption_layers+1,1)=0; %The covered surface area in the final layer equals zero (cm2)
Uncovered_molec(adsorption_layers+1,1)=Thetas(adsorption_layers+1,1)-Covered_molec(adsorption_layers+1,1); % Uncovered surface area of the final layer (cm2)
if Uncovered_molec(adsorption_layers+1,1)+Covered_molec(adsorption_layers+1,1)<=0
    Uncovered_fract(adsorption_layers+1,1)=0; %If there are no molecules in the adsorption layer the fraction of uncovered molecules in a layer is set to zero
else
%Fraction of uncovered molecules in the final adsorption layer
Uncovered_fract(adsorption_layers+1,1)=Uncovered_molec(adsorption_layers+1,1)./(Uncovered_molec(adsorption_layers+1,1)+Covered_molec(adsorption_layers+1,1)); 
end
%----------------------------------
%%%EQN 5 in Lakey et al.%%%%%%%
Ts(1)=A_surf; %True surface area of the surface material, adsorption layer 1 (cm2)
for i=1:NCom
    for j=2:adsorption_layers+1
Ts(j)=Thetas(j-1); %Surface area of other adsorption layers (cm2)
%Adsorbed concentration for adsorption layer 1 (cm-2)
Adsorbed_conc(i,1)=y((i-1).*(L_BL_close+L_BL_far+adsorption_layers+3)+L_BL_close+L_BL_far+2+1)./A_surf;
if (Thetas(j-1,1))<=0 
Adsorbed_conc(i,j)=0; %If there is no surface area for the molecules to adsorb to the concentration is 0 cm-2.
else
%Adsorbed concentration in all other layers (cm-2)
Adsorbed_conc(i,j)=y((i-1).*(L_BL_close+L_BL_far+adsorption_layers+3)+L_BL_close+L_BL_far+2+j)./(Thetas(j-1,1));
end
end
end
%----------------------------
%%%EQNS 6 and 7 in Lakey et al.%%%%%%%

for i=1:NCom
    for j=L_BL_close+L_BL_far+adsorption_layers+3
Jcoll(i,1)=W(i)./4.*y((i-1)*j+1); %Collision flux (cm-2 s-1)
%EQN6 in Lakey et al.
Jads(i,1)=a0_room_surf(i).*Jcoll(i,1).*SA_ads_layer(1,1)/A_surf; %Adsorption flux to the surface material, adsorption layer 1 (cm-2 s-1)
%EQN7 in Lakey et al.
Jdes(i,1)=kd_room_surf(i).*Uncovered_fract(1,1).*Adsorbed_conc(i,1); %Desorption flux from the surface material, adsorption layer 1 (cm-2 s-1)

for m=1:adsorption_layers
%EQN6 in Lakey et al.
Jads(i,1+m)=a0(i)*SA_ads_layer(1+m,1)/A_surf*Jcoll(i,1); %Adsorption flux to the other adsorption layers (cm-2 s-1)
if Uncovered_fract(1+m,1)<=0
    Jdes(i,1+m)=0; %If there is no uncovered fraction the desorption flux is zero (helps code run smoothly)
elseif Uncovered_fract(1+m,1)>1.1
    Jdes(i,1+m)=0; %If the uncovered fraction is unrealistically high then the desorption flux is zero (helps code run smoothly, can occur due to errors in extremely small numbers when the code is running)
else
%EQN7 in Lakey et al.
Jdes(i,1+m)=kd(i).*Uncovered_fract(1+m,1).*Adsorbed_conc(i,m+1); %Desorption flux from the other adsorption layers (cm-2 s-1)
end
end
end
end
m=L_BL_close+L_BL_far+adsorption_layers+3;
k=L_BL_close+L_BL_far+2;
for j=1:NCom
for i=1:adsorption_layers
    if (y(k+i,1)+y(m*1+k+i,1)+y(m*2+k+i,1)+y(m*3+k+i,1)+y(m*4+k+i,1)+y(m*5+k+i,1)+y(m*6+k+i,1))<1
        Jads(j,i+1)=0; %if less than 1 molecule no adsorption in the next layer
        Jdes(j,i+1)=0; %if less than 1 molecule no desorption from the next layer
    end
end
end
%-------------------------------------------
%%%%%%%Calculating parts of EQN 8 %%%%%%%
for i=1:7
    for j=1:adsorption_layers+1
        Jdes_1(i,j)=Jdes(i,j).*Ts(j)./A_surf; %part of EQN 8 in Lakey et al. (cm-2 s-1)
    end
end
for i=1:7
Jads_total(i,1)=sum(Jads(i,1:adsorption_layers+1)); %part of EQN 8 in Lakey et al. (cm-2 s-1)
Jdes_2(i,1)=sum(Jdes_1(i,1:adsorption_layers+1)); %part of EQN 8 in Lakey et al. (cm-2 s-1)
end

%%%%Differential equations: Change in concentrations and molecule numbers over time%%%%%%%
for m=L_BL_close+L_BL_far+adsorption_layers+3
for ZZ=1:Species_number
    i=Species(1,ZZ);
    %EQN 8 in Lakey et al. (Mean free path) (cm-3 s-1)
    dydt((i-1)*m+1)= (Jdes_2(i,1)-Jads_total(i,1)).*A_surf./(1*mfp(i))+...
        Dg(i)./(delta_BL_close/2).*(y((i-1)*m+2)-y((i-1)*m+1))/mfp(i);
    %Boundary layer close to the surface 1st layer (cm-3 s-1)
    dydt((i-1)*m+2)= Dg(i)./(delta_BL_close/2).*A./V_BL_close*(y((i-1)*m+1)-y((i-1)*m+2))+...
        Dg(i)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+3)-y((i-1)*m+2));
    %Boundary layer close to the surface middle layers (cm-3 s-1)
    for j=1:L_BL_close-2
    dydt((i-1)*m+2+j)= Dg(i)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+1+j)-y((i-1)*m+2+j))+...
        Dg(i)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+3+j)-y((i-1)*m+2+j));
    end
    %Boundary layer close to the surface final layer (cm-3 s-1)
    dydt((i-1)*m+L_BL_close+1)=Dg(i)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+L_BL_close)-y((i-1)*m+L_BL_close+1))+...
        Dg(i)./(delta_BL_close/2+delta_BL_far/2).*A./V_BL_close*(y((i-1)*m+L_BL_close+2)-y((i-1)*m+L_BL_close+1)); 
    %Boundary layer further away from the surface 1st layer (cm-3 s-1)
    dydt((i-1)*m+L_BL_close+2)=Dg(i)./(delta_BL_close/2+delta_BL_far/2).*A./V_BL_far*(y((i-1)*m+L_BL_close+1)-y((i-1)*m+L_BL_close+2))+...
        Dg(i)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+L_BL_close+3)-y((i-1)*m+L_BL_close+2)); 
    %Boundary layer further away from the surface middle layers (cm-3 s-1)
    for j=1:L_BL_far-2
    dydt((i-1)*m+L_BL_close+2+j)= Dg(i)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+1+L_BL_close+j)-y((i-1)*m+2+L_BL_close+j))+...
        Dg(i)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+3+L_BL_close+j)-y((i-1)*m+2+L_BL_close+j));
    end
    %Boundary layer further away from the surface final layer (cm-3 s-1)
    dydt((i-1)*m+L_BL_close+L_BL_far+1)= Dg(i)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+L_BL_close+L_BL_far)-y((i-1)*m+L_BL_close+L_BL_far+1))+...
        Dg(i)./(delta_BL_far/2).*A./V_BL_far*(y((i-1)*m+L_BL_close+L_BL_far+2)-y((i-1)*m+L_BL_close+L_BL_far+1));
    %gas phase (cm-3 s-1)
    dydt((i-1)*m+L_BL_close+L_BL_far+2)=0;
    for k=1:adsorption_layers+1
    %Molecules adsorbed to the surface in the different layers (s-1)
    %EQN9 in Lakey et al.
    dydt((i-1)*m+L_BL_close+L_BL_far+2+k)= (Jads(i,k).*A_surf-Jdes(i,k).*Ts(k));
    end     
end

end
end
